using System;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Security;
using System.Collections.Specialized;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Net.Cache;
using System.Web;
using System.Reflection;
using System.Web.Compilation;
using System.CodeDom.Compiler;
using System.Configuration;
using mshtml;
using System.DirectoryServices;

namespace CSharpRecipes
{
	public class Web
	{
		private static string GetWebAppPath()
		{
			// odczytanie cieki dostpu do aplikacji
			string path = Path.GetDirectoryName(Process.GetCurrentProcess().MainModule.FileName);

			#region Kod umoliwiajcy prac w trybie debugowania...
			// ustalenie lokalizacji, w ktrej znajduje si kod WWW
            // powinien to by katalog ssiadujcy z katalogiem aplikacji konsolowej
			string cscbWebPath = path;
			int index = -1;
			// odczytywanie kolejnych katalogw, a znaleziony zostanie katalog waciwy
			while (!Directory.Exists(cscbWebPath + @"\CSCBWeb"))
			{
				index = cscbWebPath.LastIndexOf('\\');
				if (index == -1)
				{
					cscbWebPath = "";
					break;
				}
				cscbWebPath = cscbWebPath.Substring(0, index);
			}
			#endregion

			// upewnienie si, e znana jest cieka WWW
			if (cscbWebPath.Length > 0)
			{
				// dodanie nazwy katalogu WWW
				cscbWebPath += @"\CSCBWeb";
			}
			return cscbWebPath;
        }


        #region 14.1 Odczytywanie nazwy komputera na podstawie adresu IP
        public static void ConvertIPToHostName()
		{			
            try
            {
                // uycie klasy Dns do odczytania nazwy komputera o wskazanym adresie IP
                IPHostEntry iphost = Dns.GetHostEntry("213.186.88.113");
                
                // nazwa komputera jest dostpna we waciwoci HostName
                string hostName = iphost.HostName;
                
                // wywietlenie nazwy komputera
                Console.WriteLine(hostName);
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
            }
		}
		#endregion

        #region 14.2 Odczytywanie adresu IP komputera o podanej nazwie
        public static void ConvertingHostNameToIP()
		{
            // wywietla cig znakw w postaci "Adres IP: 208.201.239.37;Adres IP: 208.201.239.36;"
			Console.WriteLine(HostName2IP("www.oreilly.com"));
        }

		public static string HostName2IP(string hostname)
		{
			// przeksztacenie nazwy komputera w iphost przy uyciu klasy dns
            IPHostEntry iphost = System.Net.Dns.GetHostEntry(hostname);
            // odczytanie wszystkich moliwych adresw IP komputera o podanej nazwie
			IPAddress[] addresses = iphost.AddressList;
			// utworzenie tekstowej reprezentacji listy
			StringBuilder addressList = new StringBuilder();
			// odczytanie wszystkich adresw IP
			foreach (IPAddress address in addresses)
			{
				// dodanie adresu do listy
                addressList.AppendFormat("Adres IP: {0};", address.ToString());
			}
			return addressList.ToString();
		}

		#endregion

		#region 14.3 Parsowanie URI
		public static void ParsingURI()
		{
			Web.ParseUri("http://uytkownik:haso@localhost:8080/www.abc.com/strona%20domowa.htm?element=1233#punkt");
		}
		public static void ParseUri(string uriString)
		{
			try
			{
		        // uycie jednego z konstruktorw klasy System.Net.Uri
		        // konstruktor wykona parsowanie
		        Uri uri = new Uri(uriString);
		        // odczytanie aktualnie dostpnych informacji...
		        StringBuilder uriParts = new StringBuilder();
		        uriParts.AppendFormat("URI bezwzgldne: {0}{1}",
                                    uri.AbsoluteUri,Environment.NewLine);
		        uriParts.AppendFormat("cieka bezwzgldna: {0}{1}",
                                    uri.AbsolutePath,Environment.NewLine);
		        uriParts.AppendFormat("Schemat: {0}{1}",
                                    uri.Scheme,Environment.NewLine);
		        uriParts.AppendFormat("Uytkownik: {0}{1}",
                                    uri.UserInfo,Environment.NewLine);
		        uriParts.AppendFormat("Uprawnienie: {0}{1}",
                                    uri.Authority,Environment.NewLine);
		        uriParts.AppendFormat("DNS komputera: {0}{1}",
                                    uri.DnsSafeHost,Environment.NewLine);
		        uriParts.AppendFormat("Komputer: {0}{1}",
                                    uri.Host,Environment.NewLine);
		        uriParts.AppendFormat("Typ nazwy komputera: {0}{1}",
                                    uri.HostNameType.ToString(),Environment.NewLine);
		        uriParts.AppendFormat("Port: {0}{1}",uri.Port,Environment.NewLine);
		        uriParts.AppendFormat("cieka: {0}{1}",uri.LocalPath,Environment.NewLine);
		        uriParts.AppendFormat("Cig zapytania: {0}{1}",uri.Query,Environment.NewLine);
		        uriParts.AppendFormat("cieka i cig zapytania: {0}{1}",
                                    uri.PathAndQuery,Environment.NewLine);
		        uriParts.AppendFormat("Fragment: {0}{1}",uri.Fragment,Environment.NewLine);
		        uriParts.AppendFormat("Cig oryginalny: {0}{1}",
                                    uri.OriginalString,Environment.NewLine);
		        uriParts.AppendFormat("Segmenty: {0}",Environment.NewLine);
		        for (int i = 0; i < uri.Segments.Length; i++)
			        uriParts.AppendFormat("	Segment {0}:{1}{2}",
                                    i, uri.Segments[i], Environment.NewLine);


		        // do odczytania najczciej uywanych kombinacji informacji o URI
                // mona uy metody GetComponents
		        uriParts.AppendFormat("Metoda GetComponents do odczytania specjalizowanych kombinacji: {0}",
                        	        Environment.NewLine);
		        uriParts.AppendFormat("Komputer i port (bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.HostAndPort,
                                    UriFormat.Unescaped),Environment.NewLine);
		        uriParts.AppendFormat("URL HTTP (bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.HttpRequestUrl, 
						            UriFormat.Unescaped),Environment.NewLine);
                uriParts.AppendFormat("URL HTTP (z sekwencjami ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.HttpRequestUrl, 
						            UriFormat.UriEscaped),Environment.NewLine);
                uriParts.AppendFormat("URL HTTP (bezpieczny, bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.HttpRequestUrl, 
						            UriFormat.SafeUnescaped),Environment.NewLine);
		        uriParts.AppendFormat("Schemat i serwer (bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.SchemeAndServer, 
						            UriFormat.Unescaped),Environment.NewLine);
		        uriParts.AppendFormat("Cig znakw SerializationInfo (bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.SerializationInfoString, 
						            UriFormat.Unescaped),Environment.NewLine);
		        uriParts.AppendFormat("Zabezpieczenie StrongAuthority (bez sekwencji ucieczki): {0}{1}",
					                uri.GetComponents(UriComponents.StrongAuthority, 
						            UriFormat.Unescaped),Environment.NewLine);
		        uriParts.AppendFormat("StrongPort (bez sekwencji ucieczki): {0}{1}",
				                    uri.GetComponents(UriComponents.StrongPort, 
						            UriFormat.Unescaped),Environment.NewLine);

		        // wywietlenie podsumowania
		        Console.WriteLine(uriParts.ToString());
			}
			catch (ArgumentNullException e)
			{
				// uriString jest odwoaniem null (Nothing w jzyku Visual Basic)
				Console.WriteLine("Cig URI jest odwoaniem null: {0}", e);
			}
			catch (UriFormatException e)
			{
				Console.WriteLine("Bd formatowania URI: {0}", e);
			}
		}

		#endregion

        #region 14.4 Formowanie i weryfikacja URI bezwzgldnego
        public static void FormingAbsoluteURI()
		{
			Uri myUri = CreateAndVerifyAbsoluteUri("http://www.helion.pl",
				"strona%20domowa.htm");

			// wywietla http://www.helion.pl/strona domowa.htm
			Console.WriteLine(myUri.AbsoluteUri);
		}

		public static Uri CreateAndVerifyAbsoluteUri(string uriBaseString, string uriRelativeString)
		{
			try
			{
				// utworzenie podstawowego URI
				Uri baseUri = new Uri(uriBaseString,UriKind.Absolute);
				// utworzenie URI wzgldnego
				Uri relativeUri = new Uri(uriRelativeString, UriKind.Relative);
				// utworzenie penego URI - poczenie URI podstawowego i wzgldnego
				Uri absoluteUri = new Uri(baseUri, relativeUri);

				// weryfikacja, e powsta URI bezwzgldny
				if(absoluteUri.IsAbsoluteUri==false)
					throw new UriFormatException(
						"Niemoliwe utworzenie URI bezwzgldnego z " + 
						baseUri.OriginalString + " oraz " + 
						relativeUri.OriginalString);

				// upewnienie si, e oryginalny podstawowy URI jest URI podstawowym
                // w nowym URI bezwzgldnym                
				if(baseUri.IsBaseOf(absoluteUri)==false)
					throw new UriFormatException(
						"URI podstawowy dla nowo utworzonego URI bezwzgldnego by nieprawidowy: " + 
						baseUri.OriginalString + " oraz " + 
						absoluteUri.OriginalString);

				// odczytanie URI wzgldnego jako rnicy 
				// midzy URI podstawowym i URI wzgldnym
				Uri relCheckUri = baseUri.MakeRelativeUri(absoluteUri);
				// nowy URI wzgldny powinien by identyczny z URI pocztkowymi
				if(relCheckUri != relativeUri)
					throw new UriFormatException(
						"Nie udao si utworzy identycznego URI wzgldnego z nowego URI bezwzgldnego: " +
						relCheckUri.OriginalString + " oraz " +
						absoluteUri.OriginalString);

				Uri newAbsoluteUri = new Uri(baseUri, relCheckUri);
				// sprawdzenie, czy URI nowy i oryginalny pasuj do siebie
				if(Uri.Compare(absoluteUri, newAbsoluteUri, 
					UriComponents.AbsoluteUri, UriFormat.Unescaped, 
					StringComparison.InvariantCulture) != 0)
				{
					throw new UriFormatException(
						"Nowy URI bezwzgldny nie jest rwny URI bezwzgldnemu utworzonemu na pocztku: " + 
						baseUri.OriginalString + " oraz " + 
						absoluteUri.OriginalString);
				}

				// wszystko w porzdku, mona zwrci URI
				return absoluteUri;
			}
			catch (ArgumentNullException e)
			{
                // uriString jest odwoaniem null (Nothing w jzyku Visual Basic) 
                Console.WriteLine("Cig URI jest odwoaniem null: {0}", e);
			}
			catch (UriFormatException e)
			{
				Console.WriteLine("Bd formatowania URI: {0}", e);

			}
			return null;
		}

		#endregion

        #region 14.5 Obsuga bdw serwera WWW
        public enum ResponseCategories
		{
			Unknown = 0,        // kod nieznany  ( < 100 lub > 599)
			Informational = 1,  // kod informacji (100 <= 199)
			Success = 2,        // kod powodzenia operacji (200 <= 299)
			Redirected = 3,     // kod przekierowania (300 <= 399)
			ClientError = 4,    // kod bdu klienta (400 <= 499)
			ServerError = 5     // kod bdu serwera (500 <= 599)
		}

		public static void HandlingWebServerErrors()
		{
			HttpWebRequest httpRequest = null;
			// odczytanie obiektu URI
			Uri uri = new Uri("http://localhost");
			// utworzenie wywoania pocztkowego
			httpRequest = (HttpWebRequest)WebRequest.Create(uri);
			HttpWebResponse httpResponse = null;
			try
			{
				httpResponse = (HttpWebResponse)httpRequest.GetResponse();
			}
			catch (WebException we)
			{
				Console.WriteLine(we.ToString());
				return;
			}
			switch (VerifyResponse(httpResponse))
			{
				case ResponseCategories.Unknown:
					Console.WriteLine("Nieznany");
					break;
				case ResponseCategories.Informational:
					Console.WriteLine("Informacyjny");
					break;
				case ResponseCategories.Success:
					Console.WriteLine("Powodzenie");
					break;
				case ResponseCategories.Redirected:
					Console.WriteLine("Przekierowanie");
					break;
				case ResponseCategories.ClientError:
					Console.WriteLine("Bd klienta");
					break;
				case ResponseCategories.ServerError:
					Console.WriteLine("Bd serwera");
					break;

			}
		}

		public static ResponseCategories VerifyResponse(HttpWebResponse httpResponse)
		{
			// na wypadek, gdyby w przyszoci w HttpStatusCode zdefiniowano 
            // wiksz liczb kodw powodzenia, sprawdzane bd "zakresy"
            // kodw powodzenia zamiast wartoci HttpStatusCode, w ktrej
            // niektre wartoci s przeciane            
			int statusCode = (int)httpResponse.StatusCode;
			if ((statusCode >= 100) && (statusCode <= 199))
			{
				return ResponseCategories.Informational;
			}
			else if ((statusCode >= 200) && (statusCode <= 299))
			{
				return ResponseCategories.Success;
			}
			else if ((statusCode >= 300) && (statusCode <= 399))
			{
				return ResponseCategories.Redirected;
			}
			else if ((statusCode >= 400) && (statusCode <= 499))
			{
				return ResponseCategories.ClientError;
			}
			else if ((statusCode >= 500) && (statusCode <= 599))
			{
				return ResponseCategories.ServerError;
			}
			return ResponseCategories.Unknown;
		}

		#endregion

        #region 14.6 Komunikacja z serwerem WWW
        public static void CommunicatingWithWebServer()
		{
            HttpWebRequest request =                
                GenerateHttpWebRequest("http://localhost/mojawitryna/index.aspx");

            using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
            {
                // uycie metody VerifyResponse z Receptury 14.5
                if (VerifyResponse(response) == ResponseCategories.Success)
                {
                    Console.WriteLine("danie zakoczyo si powodzeniem");
                }
            }
		}

        // wersja przeciona dla dania GET
        public static HttpWebRequest GenerateHttpWebRequest(string uriString)
        {
            // pobranie obiektu URI
            Uri uri = new Uri(uriString);
            // utworzenie dania pocztkowego
            HttpWebRequest httpRequest = (HttpWebRequest)WebRequest.Create(uri);
            // zwrcenie dania
            return httpRequest;
        }

        // wersja przeciona dla dania POST
        public static HttpWebRequest GenerateHttpWebRequest(string uriString,
	        string postData,
            string contentType)
        {
            // pobranie obiektu URI
	        Uri uri = new Uri(uriString);
            // utworzenie dania pocztkowego
            HttpWebRequest httpRequest = (HttpWebRequest)WebRequest.Create(uri);

	        // odczytanie bajtw dania
	        byte[] bytes = Encoding.UTF8.GetBytes(postData);

	        // ustawienie rodzaju zawartoci dla przesyanych danych
            httpRequest.ContentType = contentType;
            // dla formularzy "application/x-www-form-urlencoded"; 

	        // ustawienie dugoci przesyanego cigu znakw
	        httpRequest.ContentLength = postData.Length;

	        // odczytanie strumienia dania i zapisanie w nim wysyanych danych
            using (Stream requestStream = httpRequest.GetRequestStream())
            {
                requestStream.Write(bytes, 0, bytes.Length);
            }
	        // zwrcenie dania
	        return httpRequest;
        }

		#endregion

        #region 14.7 Przesyanie da przez serwer proxy
        public static void GoingThroughProxy()
		{
			HttpWebRequest request =
				GenerateHttpWebRequest("http://witrynawinternecie/mojawitryna/index.aspx");

			// dodanie informacji dla serwera proxy
			AddProxyInfoToRequest(request, "http://serwerproxy:80", "uytkownik", "haso", "domena");

            // albo skonfigurowanie da tak, by wszystkie odpowiedzi przechodziy przez ten sam proxy
            Uri proxyURI = new Uri("http://serwerproxy:80");

			// w .NET 1.1 wykonywao si nastpujce polecenie:
			// GlobalProxySelection.Select = new WebProxy(proxyURI);
			// w .NET 2.0 naley wykona nastpujce polecenie:
			WebRequest.DefaultWebProxy = new WebProxy(proxyURI);
		}

		public static HttpWebRequest AddProxyInfoToRequest(HttpWebRequest httpRequest,
			string proxyUri,
			string proxyID,
			string proxyPwd,
			string proxyDomain)
		{
			if (httpRequest != null)
			{
				// utworzenie obiektu proxy
				WebProxy proxyInfo = new WebProxy();
				// dodanie adresu uywanego serwera proxy
				proxyInfo.Address = new Uri(proxyUri);
				// wskazanie, by komunikacja z adresami lokalnymi omijaa serwer proxy
				proxyInfo.BypassProxyOnLocal = true;
				// dodanie informacji uwierzytelniajcych dla serwera proxy
				proxyInfo.Credentials = new NetworkCredential(proxyID,
					proxyPwd,
					proxyDomain);
				// przypisanie daniu informacji dla serwera proxy
				httpRequest.Proxy = proxyInfo;
			}
			// zwrcenie dania
			return httpRequest;
		}

		#endregion

        #region 14.8 Odczytywanie kodu HTML z podanego adresu URL
        public static void ObtainingHTMLFromURL()
		{
            try
            {
                string html = GetHtmlFromUrl("http://www.helion.pl");
            }
            catch (WebException e)
            {
                Console.WriteLine(e);
            }
		}

        public static string GetHtmlFromUrl(string url)
        {
	        if (string.IsNullOrEmpty(url))
		        throw new ArgumentNullException("url","Parametr ma warto null lub jest pusty");

	        string html = "";
	        HttpWebRequest request = GenerateHttpWebRequest(url);
	        using(HttpWebResponse response = (HttpWebResponse)request.GetResponse())
            {
		        if (VerifyResponse(response) == ResponseCategories.Success)
		        {
			        // odczytanie strumienia odpowiedzi
			        Stream responseStream = response.GetResponseStream();
                    // wykorzystanie czytnika strumienia, ktry obsuguje UTF8
                    using(StreamReader reader = new StreamReader(responseStream, Encoding.UTF8))
                    {
	                    html = reader.ReadToEnd();
                    }
		        }
	        }
	        return html;
        }

		#endregion

        #region 14.9 Wykorzystanie nowej kontrolki przegldarki internetowej
        // Patrz projekt WebBrowser
		#endregion 

        #region 14.10 Wizanie tabel baz danych z pamici podrczn
        // Patrz projekt CSCBWeb
		#endregion

        #region 14.11 Zapisywanie w pamici podrcznej danych z wieloma powizaniami
        // Patrz projekt CSCBWeb 
		#endregion

        #region 14.12 Prekompilacja strony ASP.NET z poziomu kodu rdowego
        public class MyClientBuildManagerCallback : ClientBuildManagerCallback
		{
			public MyClientBuildManagerCallback()
				: base()
			{
			}

			public override void ReportCompilerError(CompilerError error)
			{
				string msg = "Raport o bdzie kompilatora: " + error.ToString();
				Debug.WriteLine(msg);
				Console.WriteLine(msg);
			}

			public override void ReportParseError(ParserError error)
			{
				string msg = "Raport o bdzie parsowania: " + error.ToString();
				Debug.WriteLine(msg);
				Console.WriteLine(msg);
			}

			public override void ReportProgress(string message)
			{
				string msg = "Raport postpu: " + message;
				Debug.WriteLine(msg);
				Console.WriteLine(msg);
			}
		}

		public static void TestBuildASPNETPages()
		{
			try
			{
				// odczytanie cieki dostpu do aplikacji WWW
				string cscbWebPath = GetWebAppPath();

				// upewnienie si, e znana jest cieka WWW
				if(cscbWebPath.Length>0)
				{
					string appVirtualDir = @"CSCBWeb";
					string appPhysicalSourceDir = cscbWebPath;
					// katalog docelowy musi ssiadowa z katalogiem aplikacji,
                    // poniewa nie moe on si znajdowa w tym samym drzewie;
                    // w takiej sytuacji zwracany jest bd menedera kompilacji                    
					string appPhysicalTargetDir = Path.GetDirectoryName(cscbWebPath) + @"\BuildCSCB"; 

					// ponowne sprawdzenie znacznikw w Beta2, pozostae opcje...
					//AllowPartiallyTrustedCallers   
					//Clean   
					//CodeAnalysis   
					//Default   
					//DelaySign   
					//FixedNames   
					//ForceDebug   
					//OverwriteTarget   
					//Updatable 

					PrecompilationFlags flags = PrecompilationFlags.ForceDebug |
												PrecompilationFlags.OverwriteTarget;

                    ClientBuildManagerParameter cbmp = new ClientBuildManagerParameter();
                    cbmp.PrecompilationFlags = flags;
					ClientBuildManager cbm =
							new ClientBuildManager(appVirtualDir, 
													appPhysicalSourceDir, 
													appPhysicalTargetDir,
                                                    cbmp);
					MyClientBuildManagerCallback myCallback = new MyClientBuildManagerCallback();
					cbm.PrecompileApplication(myCallback);
				}
			}
			catch (Exception e)
			{
				Debug.WriteLine(e.ToString());
			}
		}
		#endregion

        #region 14.13 Uwzgldnianie i pomijanie sekwencji ucieczki w danych dla sieci WWW
        public static void TestEscapeUnescape()
		{
            string data = "<H1>Mj html</H1>";
            Console.WriteLine("Dane oryginalne: {0}",data);
            Console.WriteLine();
            // public static string EscapeDataString(string stringToEscape);
            string escapedData = Uri.EscapeDataString(data);
            Console.WriteLine("Dane z sekwencjami ucieczki: {0}",escapedData);
            Console.WriteLine();
            // public static string UnescapeDataString(	string stringToUnescape);
            string unescapedData = Uri.UnescapeDataString(escapedData);
            Console.WriteLine("Dane bez sekwencji ucieczki: {0}",data);
            Console.WriteLine();
            string uriString = "http://uytkownik:haso@localhost:8080/www.abc.com/" + 
	            "strona domowa.htm?element=1233;html=<h1>Nagwek</h1>#punkt";
            Console.WriteLine("Oryginalny cig Uri: {0}",uriString);
            Console.WriteLine();

            // public static string EscapeUriString(string stringToEscape);
            string escapedUriString = Uri.EscapeUriString(uriString);
            Console.WriteLine("Cig Uri z sekwencjami ucieczki: {0}",escapedUriString);
            Console.WriteLine();

            // dlaczego nie uy EscapeDataString, aby zastosowa 
            // sekwencje ucieczki w Uri? 
            string escapedUriData = Uri.EscapeDataString(uriString);
            Console.WriteLine("Dane Uri z sekwencjami ucieczki: {0}",escapedUriData);
            Console.WriteLine();

            Console.WriteLine(Uri.UnescapeDataString(escapedUriString));
		}
		



		#endregion

        #region 14.14 Wykorzystanie klasy UriBuilder
        public class UriBuilderFix : UriBuilder
        {
	        public UriBuilderFix() : base()
	        {
	        }

	        public new string Query
	        {
		        get
		        {
			        return base.Query;
		        }
 		        set
		        {
			        if (!string.IsNullOrEmpty(value))
			        {
				        if (value[0] == '?')
					        // Usunicie pocztkowych znakw ?, ktre 
                            // do cigu zapytania dodaje bazowa klasa UriBuilder,
                            // a take dopisanie ; przed dodatkowymi elementami                            
					        base.Query = value.Substring(1);
				        else
					        base.Query = value;
			        }
			        else
				        base.Query = string.Empty;
		        }
	        }
        }
		
		public static void TestUriBuilder()
		{
			try
			{
                UriBuilderFix ubf = new UriBuilderFix();
                ubf.Scheme = "http";
                ubf.UserName = "uytkownik";
                ubf.Password = "haso";
                ubf.Host = "localhost";
                ubf.Port = 8080;
                ubf.Path = "www.abc.com/strona domowa.htm";

                //Waciwo Query przechowuje wszystkie informacje zawarte w URI.
                //Zapytanie jest oddzielone od cieki znakiem zapytania (?) i cignie
                //si do koca URI. Zwracane zapytanie jest poprzedzone znakiem zapytania.
                //Przypisanie waciwoci Query wartoci null lub System.String.Empty
                //czyci zawarto waciwoci.
                //UWAGA: Nie naley dokleja cigu znakw bezporednio do waciwoci Query.
                //Zamiast tego trzeba odczyta warto waciwoci jako cig znakw, usun
                //pocztkowy znak zapytania, doklei nowy cig zapytania
                //i przypisa waciwoci poczony cig znakw.                

                // Tak nie naley robi - po kadej takiej operacji przybdzie jeden ?
                ubf.Query = "element=1233";
                ubf.Query += ";html=<h1>Nagwek</h1>";

                ubf.Fragment = "punkt";

                Console.WriteLine("Bezwzgldny poczony URI: " + ubf.Uri.AbsoluteUri); 
                Console.WriteLine("Poczony URI: " + ubf.ToString());

                UriBuilder ub = new UriBuilder();
                ub.Query = "element=1233";
                ub.Query += ";html=<h1>Nagwek</h1>";
				
			}
			catch (Exception e)
			{
				Console.WriteLine("Wyjtek wyrzucony w trakcie tworzenia URI: " + e.ToString());
			}
		}
		#endregion

        #region 14.15 Analiza i zmiana konfiguracji aplikacji sieciowej
        // Patrz projekt CSCBWeb
		#endregion

        #region 14.16 Praca z kodem HTML
        public static void TestHTMLParser()
		{
			HTMLDocument htmlDoc = new HTMLDocument();
			IHTMLDocument2 iHtmlDoc2 = null;

            string html = 
                "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"" +
                "\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" +
                "<html xmlns=\"http://www.w3.org/1999/xhtml\" >" + 
                "<head><title>Strona tesotwa</title></head>" +
                "<body><form method=\"post\" action=\"Default.aspx\" id=\"form1\">" +
                "<div><input id=\"Text1\" type=\"text\" />" +
                "<input id=\"Checkbox1\" type=\"checkbox\" />" +
                "<input id=\"Radio1\" type=\"radio\" />" +
                "<select id=\"Select1\">" +
                "<option selected=\"selected\"></option></select>" +
                "<input name=\"TextBox1\" type=\"text\" id=\"TextBox1\" />" +
                "</div></form></body></html>";

            // pobranie interfejsu IHTMLDocument2
            iHtmlDoc2 = (IHTMLDocument2)htmlDoc;

            // przeczenie dokumentu w tryb projektowania,
            // aby w trakcie adowania nie byy wykonywane skrypty            
            iHtmlDoc2.designMode = "On";

            // przed uyciem naley umieci kod HTML
            iHtmlDoc2.write(html);

            // zamknicie
            iHtmlDoc2.close();

            // przejcie przez wszystkie elementy kodu HTML
            foreach (IHTMLElement htmlElem in (IHTMLElementCollection)iHtmlDoc2.body.all)
            {
	            // UWAGA: za kadym razem, gdy uywane s is i as, wykonywane jest wywoanie
                // COM obiektu MSHTML. Jest to operacja do kosztowna, dlatego
                // warto zapisa jego wynik w pamici podrcznej zamiast wywoywa
                // waciwoci i zwrotnie komunikowa si z serwerem.              
	            if (htmlElem is IHTMLAnchorElement)
	            {
                    HTMLAnchorElementClass anchor = htmlElem as HTMLAnchorElementClass;
		            if (anchor != null)
			            Console.WriteLine("Znaleziony element zakotwiczenia: " + anchor.href);
		            continue;
	            }
	            else if (htmlElem is IHTMLFormElement)
	            {
                    HTMLFormElementClass form = htmlElem as HTMLFormElementClass;
		            if (form != null)
			            Console.WriteLine("Znaleziony element formularza: " + form.id);
		            continue;
	            }
                else if (htmlElem is IHTMLGenericElement)
                {
                    HTMLGenericElementClass genElem = htmlElem as HTMLGenericElementClass;
                    if (genElem != null)
                        Console.WriteLine("Znaleziony element wejciowy: " + genElem.scopeName + "." + genElem.id);
                    continue;
                }
                else if (htmlElem is IHTMLInputElement)
	            {
                    HTMLInputElementClass input = htmlElem as HTMLInputElementClass;
		            if (input != null)
			            Console.WriteLine("Znaleziony element wejciowy: " + input.id);
		            continue;
	            }
	            else if (htmlElem is HTMLTextAreaElementClass)
	            {
                    HTMLTextAreaElementClass text = htmlElem as HTMLTextAreaElementClass;
		            if (text != null)
			            Console.WriteLine("Znaleziony element obszaru tekstu: " + text.name);
		            continue;
	            }

            }

		}
		#endregion

        #region 14.17 Zwikszanie wydajnoci pracy z HTTP przez zapisywanie wynikw w pamici podrcznej
        public static void TestCache()
		{
			// receptura 14.6 posiada generategetorpostrequest
			string html = "";
			string url = "http://www.helion.pl";
            
            // konfiguracja dania
			HttpWebRequest request = GenerateHttpWebRequest(url);

            // zdefiniowanie polityki pamici podrcznej tak, by w miar
            // moliwoci uywane byy dane pochodzce z pamici podrcznej
			// domylnie w machine.config ustawiona jest polityka BypassCache,
            // aby obchodzi pami podrczn
			RequestCachePolicy rcpCheckCache = 
				new RequestCachePolicy(RequestCacheLevel.CacheIfAvailable);
			
			// przypisanie daniu nowej polityki
			request.CachePolicy = rcpCheckCache;

			// wykonanie dania
			HttpWebResponse response = null;
			try
			{
				response = (HttpWebResponse)request.GetResponse();
			    // sprawdzenie, czy skorzystano z pamici podrcznej
			    if(response.IsFromCache==false)
			    {
				    Console.WriteLine("Nie skorzystano z pamici podrcznej");
			    }

			    // pobranie strumienia odpowiedzi
			    Stream responseStream = response.GetResponseStream();
			    // uycie strumienia odczytujcego dane w formacie UTF8
			    StreamReader reader = new StreamReader(responseStream, Encoding.UTF8);

			    try
			    {
				    html = reader.ReadToEnd();
			    }
			    finally
			    {
				    // zamknicie obiektu czytajcego
				    reader.Close();
			    }
			    Console.WriteLine("Uzyskany kod HTML: " + html);
			}
			catch (WebException we)
			{
				Console.WriteLine(we.ToString());
			}
		}
		#endregion 

        #region 14.18 Sprawdzanie wasnych stron obsugi bdw uywanych przez serwer
        public static void GetCustomErrorPageLocations()
        {
            // MetaEdit jest dostpny pod adresem: http://support.microsoft.com/kb/q232068/
            // Waciwoci metabazy opisano pod adresem
            // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/iissdk/html/4930f687-3a39-4f7d-9bc7-56dbb013d2b5.asp

            // ycie w wiecie COM nie jest atwe...
            UInt32 E_RPC_SERVER_UNAVAILABLE = 0x800706BA;

            try
            {
                // wielko liter w tym elemencie metabazy ma znaczenie
                // na pierwszy rzut oka zawiera bd, ale to wcale nie prawda...
                const string WebServerSchema = "IIsWebServer";

                // wskazanie lokalnego serwera IIS
                string server = "localhost";

                // Utworzenie w sowniku wpisu dla serwera IIS wraz z przykadowym
                // uytkownikiem i hasem. Jeli uywany bdzie prawdziwy uytkownik,
                // konieczne bdzie podanie jego danych uwierzytelniajcych.                
                using (DirectoryEntry w3svc = 
                    new DirectoryEntry(
                        string.Format("IIS://{0}/w3svc", server), 
                            "Domena/KodUytkownika", "Haso"))
                {
                    // z jakiego powodu nie udao si nawiza poczenia z metabaz-wyjcie
                    if (w3svc != null)
                    {
                        foreach (DirectoryEntry site in w3svc.Children)
                        {
                            if (site != null)
                            {
                                using (site)
                                {
                                    // sprawdzenie wszystkich serwerw WWW na komputerze
                                    if (site.SchemaClassName == WebServerSchema)
                                    {
                                        // odczytanie elementu metabazy dla serwera
                                        string metabaseDir = 
                                            string.Format("/w3svc/{0}/ROOT", site.Name);

                                        if (site.Children != null)
                                        {
                                            // odnalezienie katalogu ROOT kadego serwera
                                            foreach (DirectoryEntry root in site.Children)
                                            {
                                                using (root)
                                                {
                                                    // czy znaleziono katalog gwny witryny?
                                                    if (root != null && 
                                                        root.Name.Equals("ROOT", 
                                                            StringComparison.OrdinalIgnoreCase))
                                                    {
                                                        // odczytanie bdw HTTP HttpErrors
                                                        if (root.Properties.Contains("HttpErrors") == true)
                                                        {
                                                            // zwrcenie bdw
                                                            PropertyValueCollection httpErrors = root.Properties["HttpErrors"];
                                                            if (httpErrors != null)
                                                            {
                                                                for (int i = 0; i < httpErrors.Count; i++)
                                                                {
                                                                    //400,*,FILE,C:\WINDOWS\help\iisHelp\common\400.htm
                                                                    string[] errorParts = httpErrors[i].ToString().Split(',');
                                                                    Console.WriteLine("Bd odwzorowywania elementu:");
                                                                    Console.WriteLine("\tKod bdu HTTP: {0}", errorParts[0]);
                                                                    Console.WriteLine("\tKod subbdu HTTP: {0}", errorParts[1]);
                                                                    Console.WriteLine("\tTyp komunikatu: {0}", errorParts[2]);
                                                                    Console.WriteLine("\tcieka do pliku HTML bdu: {0}", errorParts[3]);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (COMException e)
            {
                // w tym momencie serwer nie odpowiada
                // kod mona umieci w ptli, by prbowa dalej...
                if (e.ErrorCode != (Int32)E_RPC_SERVER_UNAVAILABLE)
                {
                    throw;
                }
            }
        }
        #endregion

        #region 14.19 Odczytywanie odwzorowa aplikacji dla ASP.NET zdefiniowanych na serwerze IIS
        public static void DumpASPNETAppMappings()
        {
            // MetaEdit jest dostpny pod adresem: http://support.microsoft.com/kb/q232068/
            // Waciwoci metabazy opisano pod adresem
            // http://msdn.microsoft.com/library/default.asp?url=/library/en-us/iissdk/html/4930f687-3a39-4f7d-9bc7-56dbb013d2b5.asp

            // ycie w wiecie COM nie jest atwe...
            UInt32 E_RPC_SERVER_UNAVAILABLE = 0x800706BA;

            try
            {
                // wielko liter w tym elemencie metabazy ma znaczenie
                // na pierwszy rzut oka zawiera bd, ale to wcale nie prawda...
                const string WebServerSchema = "IIsWebServer";

                // wskazanie lokalnego serwera IIS
                string server = "localhost";

                // Utworzenie w sowniku wpisu dla serwera IIS wraz z przykadowym
                // uytkownikiem i hasem. Jeli uywany bdzie prawdziwy uytkownik,
                // konieczne bdzie podanie jego danych uwierzytelniajcych.
                using (DirectoryEntry w3svc = new DirectoryEntry(string.Format("IIS://{0}/w3svc", server), "Domain/UserCode", "Password"))
                {
                    // z jakiego powodu nie udao si nawiza poczenia z metabaz-wyjcie
                    if (w3svc != null)
                    {
                        foreach (DirectoryEntry site in w3svc.Children)
                        {
                            using (site)
                            {
                                if (site != null)
                                {
                                    // sprawdzenie wszystkich serwerw WWW na komputerze
                                    if (site.SchemaClassName == WebServerSchema)
                                    {
                                        // odczytanie elementu metabazy dla serwera
                                        string metabaseDir =
                                            string.Format("/w3svc/{0}/ROOT", site.Name);

                                        if (site.Children != null)
                                        {
                                            // odnalezienie katalogu ROOT kadego serwera
                                            foreach (DirectoryEntry root in site.Children)
                                            {
                                                using (root)
                                                {
                                                    // czy znaleziono katalog gwny witryny?
                                                    if (root != null &&
                                                        root.Name.Equals("ROOT", StringComparison.OrdinalIgnoreCase))
                                                    {
                                                        // pobranie odwzorowa aplikacji z waciwoci ScriptMaps
                                                        if (root.Properties.Contains("ScriptMaps") == true)
                                                        {
                                                            // wypisanie odwzorowa
                                                            PropertyValueCollection scriptMaps = root.Properties["ScriptMaps"];
                                                            if (scriptMaps != null)
                                                            {
                                                                for (int i = 0; i < scriptMaps.Count; i++)
                                                                {
                                                                    //.aspx,C:\WINDOWS\Microsoft.NET\Framework\v2.0.50110\aspnet_isapi.dll,1,GET,HEAD,POST,DEBUG
                                                                    string[] mappingParts = scriptMaps[i].ToString().Split(',');
                                                                    // przekierowanie ASP.NET jest zaimplementowane w pliku
                                                                    // aspnet_isapi.dll, a wic wszystkie rozszerzenia odwzorowane
                                                                    // na ten plik bd przetwarzane przez asp.net                                                                    
                                                                    if (mappingParts[1].ToUpper().IndexOf("ASPNET_ISAPI") != -1)
                                                                    {
                                                                        // szczegowe informacje o odwzorowaniach ASP.NET
                                                                        Console.WriteLine("Odwzorowania rozszerze:");
                                                                        Console.WriteLine("\tOdwzorowane rozszerzenie: {0}", mappingParts[0]);
                                                                        Console.WriteLine("\tUchwyt: {0}", mappingParts[1]);
                                                                        for (int j = 3; j < mappingParts.Length; j++)
                                                                            Console.WriteLine("\tCzasownik HTTP: {0}", mappingParts[j]);
                                                                    }
                                                                    else
                                                                    {
                                                                        // wypisanie elementw, ktre nie s odwzorowane
                                                                        Console.WriteLine("Pominicie {0} -  nie jest przetwarzane przez ASP.NET", mappingParts[0]);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (COMException e)
            {
                // w tym momencie serwer nie odpowiada
                // kod mona umieci w ptli, by prbowa dalej...
                if (e.ErrorCode != (Int32)E_RPC_SERVER_UNAVAILABLE)
                {
                    throw;
                }
            }
        }
        #endregion
	}
}
